import xml.etree.ElementTree as ET
import pickle
import os
import cv2
from os import listdir, getcwd
from os.path import join

rootdir="/home/star/darknet/data_face"
classes = ["face"]
 
def convert(size, box):
    dw = 1./size[0]
    dh = 1./size[1]
    x = (box[0] + box[1])/2.0
    y = (box[2] + box[3])/2.0
    w = box[1] - box[0]
    h = box[3] - box[2]
    x = x*dw
    w = w*dw
    y = y*dh
    h = h*dh
    return (x,y,w,h)
 
def convert_annotation(w,h, image_id):
    in_file = open(rootdir+'/Annotations/%s.xml'%image_id)
    out_file = open(rootdir+'/label/%s.txt'%image_id, 'w')
    tree=ET.parse(in_file)
    root = tree.getroot()
    size = root.find('size')
    w = int(size.find('width').text)
    h = int(size.find('height').text)
 
    for obj in root.iter('object'):
        difficult = obj.find('difficult').text
        cls = obj.find('name').text
        if cls not in classes or int(difficult) == 1:
            continue
        cls_id = classes.index(cls)
        xmlbox = obj.find('bndbox')
        b = (float(xmlbox.find('xmin').text), float(xmlbox.find('xmax').text), float(xmlbox.find('ymin').text), float(xmlbox.find('ymax').text))
        bb = convert((w,h), b)
        out_file.write(str(cls_id) + " " + " ".join([str(a) for a in bb]) + '\n')
 
wd = getcwd()
 
#for year, image_set in sets:
if not os.path.exists(rootdir+'/label/'):
    os.makedirs(rootdir+'/label/')
image_ids = open(rootdir+'/ImageSets/Main/train.txt').read().strip().split()
list_file = open('fddb_train.txt', 'w')
for image_id in image_ids:
    list_file.write(rootdir+'/voc_face/%s.jpg\n'%image_id)
    image = cv2.imread(rootdir+'/voc_face/%s.jpg'%image_id)
    h, w, c = image.shape
    convert_annotation(w,h, image_id)
list_file.close()
