#!/bin/sh

#set -x

Parameter_num=$#
Parameter_one=$1
PathInstall="/opt/app/oraynewph"
USER_DATA="/tmp/oraysl.status"
ORAY_P1="oraynewph"
ORAY_P2="oraysl"

FunParamLegal()
{
    if [ ${Parameter_num} -ne 1 ]; then
        echo "Fail:Parameter Err."
        exit 1
    fi
}

CheckProgressNum()
{
	local L_NumProgress=""
	local L_Line=""
	local L_TmpFile="/tmp/NumProgress"
	local L_Tmp=""
	
	ps | grep "./${ORAY_P1}" > ${L_TmpFile}
	
	while read L_Line
	do
		L_Tmp=`echo ${L_Line} | grep "grep ./${ORAY_P1}"`
		if [ "${L_Tmp}" == "" ]; then
			L_Tmp=`echo ${L_Line} | awk -F " " '{print $5}' | awk -F " " '{print $1}'`
			if [ "${L_Tmp}" != "./${ORAY_P1}" ]; then
				continue
			else
				L_NumProgress=`echo ${L_Line} | awk -F " " '{print $1}'`
				break
			fi
		fi
		
		break			
	done < ${L_TmpFile}

	rm -f ${L_TmpFile}
	
	echo ${L_NumProgress}
}

status(){

	SN=`head -n 2 $USER_DATA  | tail -n 1 | cut -d= -f2-`;
	STATUS=`head -n 3 $USER_DATA  | tail -n 1 | cut -d= -f2-`;

	echo  "RUNSTATUS= $STATUS"
	echo  "SN= $SN"
	echo  "LoginAddress= http://b.oray.com/"

	szUID=0
	if [ -f ${PathInstall}/etc/PhMain.ini ] ; then
		szUID=`sed -n 's/.*szUID=*/\1/p' ${PathInstall}/etc/PhMain.ini`
	fi
	if [ "$szUID" != "0" ] ; then
		echo "花生壳内网版" "已经绑定的花生壳账号：$szUID"
	else
		echo "花生壳内网版" "没绑定的花生壳账号，请尽快绑定"
	fi
}


start()
{
	L_NumProgress=`CheckProgressNum`
	if [ "${L_NumProgress}" != "" ]; then
		kill -9 ${L_NumProgress}
	fi

	killall $ORAY_P1
	killall $ORAY_P2

	cd ${PathInstall}/bin

	chmod +x ${ORAY_P1}
	chmod +x ${ORAY_P2}

	./${ORAY_P1} -s 0.0.0.0 >/dev/null 2>/dev/null &
	sleep 1
	./${ORAY_P2} -a 127.0.0.1 -p 16062 -s phsle01.oray.net:80 -d >/dev/null 2>/dev/null &
	
	echo "Oraynewph start success !"
	cd -
	exit
}

stop()
{
	L_NumProgress=`CheckProgressNum`
	if [ "${L_NumProgress}" != "" ]; then
		kill -9 ${L_NumProgress}
	fi

	killall $ORAY_P1
	killall $ORAY_P2

	echo "Oraynewph already stopped !"
	exit
}

Main()
{
	if [ "${Parameter_one}" = "start" ]; then
		start
	elif [ "${Parameter_one}" = "stop" ]; then
		stop
	elif [ "${Parameter_one}" = "status" ]; then
		status
	else
		echo "Usage: $0 {start|status|stop}"
		exit 1	
	fi
}

FunParamLegal
Main
